//
//  BluetoothUITableViewCell.m
//  MHTReceipt
//
//  Created by Mac on 2018/11/6.
//  Copyright © 2018年 Mac. All rights reserved.
//

#import "BluetoothUITableViewCell.h"

@interface BluetoothUITableViewCell()

//蓝牙名称
@property (strong,nonatomic) UILabel *bluetoothNameUILabel;
//蓝牙的UUID
@property (strong,nonatomic) UILabel *bluetoothUUIDUILabel;
@property (assign,nonatomic) CGSize size;

@end

@implementation BluetoothUITableViewCell

-(void)initUIView:(CGSize)size{
    self.size = size;
    CGFloat height = self.size.height / 2;
    CGFloat endY = 0;
    endY = [self initBluetoothNameUIView:endY withHeight:height];
    endY = [self initBluetoothUUIDUIUIView:endY withHeight:height];
}

/**
 * 设置数据，uuid代表蓝牙的唯一标识
 */
-(void)setData:(NSString *)bluetoothName withUUID:(NSString *)uuid{
    self.bluetoothNameUILabel.text = bluetoothName;
    self.bluetoothUUIDUILabel.text = uuid;
}

-(CGFloat)initBluetoothUUIDUIUIView:(CGFloat)startY withHeight:(CGFloat)height{
    UIView *bluetoothUIView = [[UIView alloc] init];
    bluetoothUIView.frame = CGRectMake(10, startY, self.size.width, height);
    [self.contentView addSubview:bluetoothUIView];
    self.bluetoothUUIDUILabel = [[UILabel alloc] init];
    self.bluetoothUUIDUILabel.font = [UIFont systemFontOfSize:12];
    self.bluetoothUUIDUILabel.frame = CGRectMake(0, 0,self.size.width, height);
    [bluetoothUIView addSubview:self.bluetoothUUIDUILabel];
    return bluetoothUIView.frame.origin.y + bluetoothUIView.frame.size.height;
}

/**
 * 初始化蓝牙名称的UIView
 */
-(CGFloat)initBluetoothNameUIView:(CGFloat)startY withHeight:(CGFloat)height{
    UIView *bluetoothUIView = [[UIView alloc] init];
    bluetoothUIView.frame = CGRectMake(10, startY, self.size.width,height);
    [self.contentView addSubview:bluetoothUIView];
    self.bluetoothNameUILabel = [[UILabel alloc] init];
    self.bluetoothNameUILabel.frame = CGRectMake(0, 0,
                                                 self.size.width, height);
    [bluetoothUIView addSubview:self.bluetoothNameUILabel];
    
    return bluetoothUIView.frame.origin.y + bluetoothUIView.frame.size.height;
}

- (void)awakeFromNib {
    [super awakeFromNib];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
